




log using nonparametric_reg.txt, text replace

**********nonparametric_regression.do **********
*Note: the data employed is the same one as in the nonparametric_density.do
************************************************

*1. example to visualize the difference between scatter plots and binned scatter plots

sysuse nlsw88
keep if inrange(age,35,44) & inrange(race,1,2)
keep if inrange(age,35,44) & inrange(race,1,2)
scatter wage tenure, graphregion(color(white)) lwidth(thick)
graph export "scat_1.pdf", replace
binscatter wage tenure, nq(50)
graph export "bin_1.pdf", replace
binscatter wage tenure, control(age) nq(50)
binscatter wage tenure,by(race) nq(50)
graph export "bin_2.pdf", replace





*2. Example (from Cameron and Trivedi)

********** SETUP **********
clear all
set more off
version 15
set scheme s1mono  /* Graphics scheme */
set linesize 82

********** DATA DESCRIPTION **********

* The original data are from the PSID Individual Level Final Release 1993 data
* From www.isr.umich.edu/src/psid  then choose Data Center 
* 4856 observations on 9 variables for Females 30 to 50 years 
* See mma09p1np.do for further description

**************************************

* Read in data, select, describe and summarize key variables
use nonparametric.dta, clear
describe 

* Work with age 36 and nonmissing education data
keep if age == 36
drop if educatn == .
summarize

**************************************
******* NONPARAMETRIC REGRESSION 
**************************************
* OLS 
regress lnhwage educatn

*visual inspection of the data
twoway scatter lnhwage educatn, graphregion(color(white)) lwidth(thick)
graph export "scatter_2.pdf", replace
binscatter lnhwage educatn, nq(20)
binscatter lnhwage educatn, nq(20) line(none)
binscatter lnhwage educatn, control(married) nq(30) line(none)





* Kernel (local constant) regression with lpoly
lpoly lnhwage educatn, ci msize(small) scale(1.1)
graph export ker_reg1.pdf, replace

*same with npregress
npregress kernel lnhwage educatn, estimator(constant) reps(100) seed(12)
npgraph


* Try different bandwidths - default, halfdefault, twicedefault
graph twoway (lpoly lnhwage educatn, bw(1.5))   ///
  (lpoly lnhwage educatn, bw(0.75) clstyle(p2)) ///
  (lpoly lnhwage educatn, bw(3.0) clstyle(p3)), scale(1.1) ///
  legend(label(1 "Default") label(2 "Half default") label(3 "Twice default")) ///
  legend(pos(11) ring(0) col(1)) 
graphregion(color(white)) lwidth(thick)
graph export "ker_reg1a.pdf", replace


************************************************
*local linear regression with lpoly; lowess
************************************************
* Local linear regression
lpoly lnhwage educatn, degree(1) ci 

* Lowess regression
lowess lnhwage educatn 

* Compare kernel, local linear, lowess with default bandwidths
graph twoway (lpoly lnhwage educ)                ///
  (lpoly lnhwage educ, degree(1) clstyle(p2))    ///
  (lowess lnhwage educ, clstyle(p3)), scale(1.1) ///
  legend( label(1 "Kernel") label(2 "Local linear") label(3 "lowess") ) ///
  legend(pos(11) ring(0) col(1))   
graph export "ker_reg2a.pdf", replace

* OLS 
regress lnhwage educatn
regress lnhwage educatn, vce(robust)

******** NPREGRESS COMMAND

* npregress command - local linear (default)
npregress kernel lnhwage educatn

* npregress with bootstrap standard errors
npregress kernel lnhwage educatn, vce(bootstrap, seed(10101) reps(50))

* 50 reps chosen to speed up program - should increase from 50 reps.

* Compute and plot predictions at various values with bootstrap st. errors
margins, at(educatn = (1(1)16)) vce(bootstrap, seed(10101) reps(50))
marginsplot, legend(off) scale(1.1)   ///
  addplot(scatter lnhwage educatn if lnhwage<50000, msize(tiny))
* graph export nonparametricfig11.wmf, replace

* Partial effects of changing education
margins, at(educatn = (10(1)16)) contrast(atcontrast(ar)) ///
    vce(bootstrap, seed(10101) reps(50))
marginsplot, legend(off)
* graph export nonparametricfig13.wmf, replace




*******************************************************
*			SERIES REGRESSION
****************************************************

npregress series lnhwage educatn







